<?php
/**
 * The batch create view file of user module of XXB.
 *
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd., www.zentao.net)
 * @license     ZOSL (https://zpl.pub/page/zoslv1.html)
 * @author      Gang Liu <liugang@cnezsoft.com>
 * @package     user
 * @version     $Id$
 * @link        https://xuanim.com
 */
?>
<?php include '../../common/view/header.html.php';?>
<?php include '../../common/view/chosen.html.php';?>
<?php $lang->genderList = (array)$lang->genderList;?>
<?php if($userLeft <= 0 && $userLeft !== false):?>
<div class='alert alert-warning'>
  <p><?php echo $lang->user->exceedUserLimit;?></p>
</div>
<?php else:?>
<div class="alert alert-warning">
  <p><?php printf($lang->user->tips->userLeft, $userLeft === false ? $lang->user->unlimited : $userLeft);?></p>
</div>

<form id='batchCreateForm' method='post'>
  <div class='panel'>
    <div class='panel-heading'><strong><?php echo str_replace('-', '', $title);?></strong></div>
    <div class='panel-body'>
      <table class='table table-form'>
        <thead>
          <tr class='text-center'>
            <th class='account w-p10 required'><?php echo $lang->user->account;?></th>
            <th class='realname w-230px required'><?php echo $lang->user->realname;?></th>
            <th class='password w-p15 required'><?php echo $lang->user->password;?></th>
            <th class='gender w-<?php echo $lang->user->genderWidth;?>px'><?php echo $lang->user->gender;?></th>
            <th class='dept w-p20'><?php echo $lang->user->dept;?></th>
            <th class='role w-p10'><?php echo $lang->user->role;?></th>
            <th class='email w-p10'><?php echo $lang->user->email;?></th>
            <th class='mobile w-p10'><?php echo $lang->user->mobile;?></th>
            <th class='phone w-p10'><?php echo $lang->user->phone;?></th>
          </tr>
        </thead>
        <tbody>
          <?php unset($lang->genderList['u']);?>
          <?php if(!empty($userList)):?>
          <?php foreach($userList as $key => $user):?>
          <tr>
            <td><?php echo html::input("account[$key]", $user->account, "id='account{$key}' class='form-control' autocomplete='off'");?></td>
            <td class='realname'>
              <div class='input-group'>
                <?php echo html::input("realname[$key]", $user->realname, "id='realname{$key}' class='form-control' autocomplete='off'");?>
                <span class='input-group-addon' style='display: none'>
                  <label class='radio-inline' data-toggle='tooltip' title="<?php echo $lang->user->tips->saveDuplicate;?>">
                    <input type='radio' name='duplicateResult[<?php echo $key;?>]' value='save'>
                    <?php echo $lang->user->duplicateResult['save'];?>
                  </label>
                  <label class='radio-inline' data-toggle='tooltip' title="<?php echo $lang->user->tips->ignoreDuplicate;?>">
                    <input type='radio' name='duplicateResult[<?php echo $key;?>]' value='ignore'>
                    <?php echo $lang->user->duplicateResult['ignore'];?>
                  </label>
                </span>
              </div>
            </td>
            <td><?php echo html::input("password[$key]", $user->password, "id='password{$key}' class='form-control' autocomplete='off'");?></td>
            <td class='text-center'><?php echo html::radio("gender[$key]", $lang->genderList, $user->gender);?></td>
            <td>
              <div class='input-group'>
                <?php echo html::select("dept[$key]", $deptList, isset($deptList[$user->dept]) ? $user->dept : 0, "id='dept{$key}' class='form-control chosen'");?>
                <?php echo html::input("deptName[$key]", isset($deptList[$user->dept]) ? '' : $user->dept, "id='deptName{$key}' class='form-control' style='display:none;' autocomplete='off' placeholder=\"{$lang->user->placeholder->emptyDept}\"");?>
                <?php $checked = isset($deptList[$user->dept]) ? '' : "checked='checked'";?>
                <span class='input-group-addon'>
                  <label class="checkbox-inline">
                    <input type="checkbox" name="createDept[<?php echo $key;?>]" value="1" <?php echo $checked;?>>
                    <?php echo $lang->create;?>
                  </label>
                </span>
              </div>
            </td>
            <td><?php echo html::select("role[$key]", $lang->user->roleList, $user->role, "id='role{$key}' class='form-control chosen'");?></td>
            <td><?php echo html::input("email[$key]", $user->email, "id='email{$key}' class='form-control' autocomplete='off'");?></td>
            <td><?php echo html::input("mobile[$key]", $user->mobile, "id='mobile{$key}' class='form-control' autocomplete='off'");?></td>
            <td><?php echo html::input("phone[$key]", $user->phone, "id='phone{$key}' class='form-control' autocomplete='off'");?></td>
          </tr>
          <?php endforeach;?>
          <?php else:?>
          <?php for($i = 0; $i < $this->config->user->batchCreateCount; $i++):?>
          <tr>
            <td class='w-p40'><?php echo html::input("account[$i]", '', "id='account{$i}' class='form-control' autocomplete='off'");?></td>
            <td>
              <div class='input-group'>
                <?php echo html::input("realname[$i]", '', "id='realname{$i}' class='form-control' autocomplete='off'");?>
                <span class='input-group-addon' style='display: none'>
                  <label class='radio-inline' data-toggle='tooltip' title="<?php echo $lang->user->tips->saveDuplicate;?>">
                    <input type='radio' name='duplicateResult[<?php echo $i;?>]' value='save'>
                    <?php echo $lang->user->duplicateResult['save'];?>
                  </label>
                  <label class='radio-inline' data-toggle='tooltip' title="<?php echo $lang->user->tips->ignoreDuplicate;?>">
                    <input type='radio' name='duplicateResult[<?php echo $i;?>]' value='ignore'>
                    <?php echo $lang->user->duplicateResult['ignore'];?>
                  </label>
                </span>
              </div>
            </td>
            <td><?php echo html::input("password[$i]", '', "id='password{$i}' class='form-control' autocomplete='off'")?></td>
            <td class='text-center'><?php echo html::radio("gender[$i]", $lang->genderList);?></td>
            <td>
              <div class='input-group'>
                <?php echo html::input("deptName[$i]", '', "id='deptName{$i}' class='form-control' style='display:none;' autocomplete='off' placeholder=\"{$lang->user->placeholder->emptyDept}\"");?>
                <?php echo html::select("dept[$i]", $deptList, '', "id='dept{$i}' class='form-control chosen'");?>
                <span class='input-group-addon'>
                  <label class="checkbox-inline">
                    <input type="checkbox" name="createDept[<?php echo $i;?>]" value="1">
                    <?php echo $lang->create;?>
                  </label>
                </span>
              </div>
            </td>
            <td><?php echo html::select("role[$i]", $lang->user->roleList, '', "id='role{$i}' class='form-control'");?></td>
            <td><?php echo html::input("email[$i]", '', "id='email{$i}' class='form-control' autocomplete='off'");?></td>
            <td><?php echo html::input("mobile[$i]", '', "id='mobile{$i}' class='form-control' autocomplete='off'");?></td>
            <td><?php echo html::input("phone[$i]", '', "id='phone{$i}' class='form-control' autocomplete='off'");?></td>
          </tr>
          <?php endfor;?>
          <?php endif;?>
        </tbody>
        <tr>
          <td colspan='7' class='text-center form-actions'>
            <?php echo html::submitButton('', 'btn btn-primary', "style='margin-right: 10px;'") . html::backButton();?>
          </td>
        </tr>
      </table>
    </div>
  </div>
</form>
<?php endif;?>
<?php include '../../common/view/footer.html.php';?>
