<?php include '../../common/view/header.html.php'; ?>
<div class="panel">
  <div class="panel-heading">
    <strong>
      <i class="icon-lock"></i> <?php echo $lang->restriction->label; ?>
    </strong>
  </div>
  <form
    method='post'
    id='ajaxForm'
    class='form-ajax <?php if ($enabled == 'open') echo 'restriction-enabled'; ?>'
  >
    <table class='table table-form'>
      <tr>
        <th>
          <strong><?php echo $lang->restriction->label; ?></strong>
        </th>
        <td>
          <div class="checkbox">
            <label>
              <input
                id="enabled"
                type="checkbox"
                name="enabled"
                value='open'
                <?php if($enabled == 'open') echo 'checked'; ?>
                <?php if($type != 'edit') echo 'disabled'; ?>
              ><?php echo $lang->restriction->open; ?>
            </label>
          </div>
        </td>
      </tr>
      <tr class="restriction-row">
        <th>
          <strong><?php echo $lang->restriction->CIDRs; ?></strong>
        </th>
      <?php if($type == 'edit'): ?>
        <td>
          <div class='required required-wrapper'></div>
          <?php echo html::textarea('cidrs', implode(PHP_EOL, $cidrs), "rows='5' class='form-control'");?>
        </td>
        <td class='text-muted'><?php echo $lang->restriction->inputError->placeholder; ?></td>
      <?php else: ?>
        <td>
          <?php foreach ($cidrs as $cidr) echo "<p>{$cidr}</p>"; ?>
        </td>
      <?php endif; ?>
      </tr>

      <tr>
        <th></th>
        <td colspan='2'>
          <?php
            echo $type == 'edit'
              ? html::submitButton()
              : html::linkButton($lang->edit, helper::createLink('restriction', 'index', 'type=edit'), 'btn btn-primary');
          ?>
        </td>
      </tr>
    </table>
  </form>
</div>
<style>
  .restriction-row {
    display: none;
  }

  #ajaxForm.restriction-enabled .restriction-row {
    display: table-row;
  }
</style>
<script>
  $(function() {
    $.setAjaxForm('#ajaxForm');
    $('#enabled').on('change', function() {
      $('#ajaxForm').toggleClass('restriction-enabled', $('#enabled').is(':checked'));
    });
  });
</script>
<?php include '../../common/view/footer.html.php';?>
