<?php
/**
 * The control file of company module of RanZhi.
 *
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd., www.zentao.net)
 * @license     ZOSL (https://zpl.pub/page/zoslv1.html)
 * @author      Chunsheng Wang <chunsheng@cnezsoft.com>
 * @package     company
 * @version     $Id: control.php 4169 2016-10-19 08:57:15Z liugang $
 * @link        http://www.ranzhi.org
 */
class company extends control
{
    /**
     * The index page.
     *
     * @access public
     * @return void
     */
    public function index()
    {
        $this->view->company = $this->company->getCompanyName();
        $this->display();
    }

    /**
     * set company basic info.
     *
     * @access public
     * @return void
     */
    public function setBasic()
    {
        if(!empty($_POST))
        {
            $this->company->updateCompanyName($this->post->name);
            $this->send(array('result' => 'success', 'message' => $this->lang->setSuccess, 'locate' => inlink('index')));
        }
        $this->view->company = $this->company->getCompanyName();
        $this->view->title = $this->lang->company->setBasic;
        $this->display();
    }
}
