<?php
/**
 * The control file of sso module of XXB.
 *
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd., www.zentao.net)
 * @license     ZOSL (https://zpl.pub/page/zoslv1.html)
 * @author      Chunsheng Wang <chunsheng@cnezsoft.com>
 * @package     sso
 * @version     $Id: control.php 4029 2016-08-26 06:50:41Z liugang $
 * @link        https://xuanim.com
 */
class sso extends control
{
    /**
     * Check privilege.
     *
     * @access public
     * @return void
     */
    public function check()
    {
        $token  = $this->get->token;
        $auth   = $this->get->auth;
        $userIP = $this->get->userIP;

        if(isset($_GET['callback']))
        {
            $callback = urldecode($this->get->callback);
            $sign     = strpos($callback, '&') === false ? '?' : '&';
        }

        $data = $this->sso->getUserBySso($token, $auth, $userIP);
        if($data !== false)
        {
            $response['status'] = 'success';
            $response['data']   = base64_encode(json_encode($data));
            $response['md5']    = md5($response['data']);

            if(!empty($_GET['referer'])) $response['referer'] = $this->get->referer;
            if(isset($callback)) $this->locate($callback . $sign . http_build_query($response));
            die(json_encode($response));
        }

        $response['status'] = 'fail';
        $response['data']   = 'check failed.';
        $response['md5']    = md5($response['data']);

        if(!empty($_GET['referer'])) $response['referer'] = $this->get->referer;
        if(isset($callback)) $this->locate($callback . $sign . http_build_query($response));
        die(json_encode($response));
    }

    /**
     * Auth user.
     *
     * @param  string $entry
     * @access public
     * @return void
     */
    public function auth($code, $account = '', $authcode = '')
    {
        if($this->post->account)  $account  = $this->post->account;
        if($this->post->authcode) $authcode = $this->post->authcode;

        $user = $this->sso->identify($code, $account, $authcode);
        if($user)
        {
            $response['status'] = 'success';
            $response['data']   = json_encode($user);
            die(json_encode($response));
        }

        $response['status'] = 'fail';
        $response['data']   = 'auth failed.';
        die(json_encode($response));
    }

    /**
     * Get todo list for ranzhi.
     *
     * @param  string  $code
     * @param  string  $account
     * @access public
     * @return void
     */
    public function getTodoList($code = '', $account = '')
    {
        $this->app->loadLang('todo');

        if(!$account) $account = $this->app->user->account;
        $datas = $this->sso->getZentaoTodoList($code, $account);

        $boardList = '';
        foreach($datas as $type => $dataList)
        {
            if(empty($dataList)) continue;

            $todos = $this->dao->select('*')->from(TABLE_TODO)->where('type')->eq("{$code}_{$type}")->fetchAll('idvalue');
            foreach($dataList as $id => $data)
            {
                if(isset($todos[$id]))
                {
                    unset($datas[$type][$id]);
                }
                else
                {
                    $datas[$type][$id] = '[' . $this->lang->todo->$type . '] ' . $data;
                }
            }

            $index = $type == 'bug' ? count($datas['task']) : 0;
            $boardList .= $this->loadModel('todo')->buildBoardList($datas[$type], $code . '_' . $type, $index);
        }
        die($boardList);
    }

    /**
     * Get leave users.
     *
     * @access public
     * @return void
     */
    public function leaveUsers()
    {
        $code = $this->get->code;

        if(!$this->sso->checkIP($code)) die('IP DENY');

        $key = $this->sso->getAppKey($code);
        if($key != $this->get->key) die('KEY ERROR');

        $yesterday = date('Y-m-d', strtotime('yesterday'));
        $leaveUsers = $this->dao->select('*')->from(TABLE_LEAVE)->where('begin')->le($yesterday)->andWhere('end')->ge($yesterday)->fetchPairs('createdBy', 'createdBy');

        die(json_encode($leaveUsers));
    }
}
