<?php
/**
 * The control file of help module of XXB.
 *
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd., www.zentao.net)
 * @license     ZOSL (https://zpl.pub/page/zoslv1.html)
 * @author      Chunsheng Wang <chunsheng@cnezsoft.com>
 * @package     help
 * @version     $Id: control.php 4227 2016-10-25 08:27:56Z liugang $
 * @link        https://xuanim.com
 */
class help extends control
{
    /**
     * The index page.
     *
     * @access public
     * @return void
     */
    public function index()
    {
        if(RUN_MODE == 'xuanxuan') die('license error');
        $this->locate(inlink('license'));
    }

    /**
     * The license page.
     *
     * @access public
     * @return void
     */
    public function license()
    {
        $this->view->title = $this->lang->help->licenseUnavaliable;

        if(isset($this->app->licenseData))
        {
            $this->view->licenseData = $this->app->licenseData;
        }
        else if($this->app->config->debug === 3)
        {
            $this->view->licenseData          = new stdClass();
            $this->view->licenseData->errType = '';
        }
        else
        {
            die(js::locate($this->createLink('index', 'index')));
        }

        $this->view->ip  = empty($this->view->licenseData->ip) ? $this->help->getServerIP() : $this->view->licenseData->ip;
        $this->view->mac = empty($this->view->licenseData->mac) ? '' : $this->view->licenseData->mac;

        $this->view->applyOfficialLicenseUrl = $this->config->help->applyLicenseAPI;
        $this->view->freeLicenseAPI          = $this->config->help->freeLicenseAPI;

        $this->display();
    }
}
