<?php
/**
 * Compare hash password use random
 *
 * @param  string    $password
 * @param  object    $user
 * @access public
 * @return void
 */
public function compareHashPassword($password, $user, $useRandomSalt = true)
{
    /* Check Hash if password leng is 40. */
    $passwordLength = strlen($password);
    if($passwordLength == 32)
    {
        $hash = $this->session->random ? md5($user->password . ($useRandomSalt ? $this->session->random : '')) : $user->password;
        if($password == $hash) return true;
        if(md5($password . $user->account) == $hash) return true;
    }

    return parent::compareHashPassword($password, $user);
}

/**
 * Set push device token.
 *
 * @param  string   $deviceToken
 * @param  string   $deviceType
 * @param  int  $userID
 * @access public
 * @return void
 */
public function setDeviceToken($deviceToken, $deviceType, $userID)
{
    if(empty($deviceToken)) $deviceType = '';
    $this->dao->update(TABLE_USER)
        ->set('deviceToken')->eq($deviceToken)
        ->set('deviceType')->eq($deviceType)
        ->where('id')->eq($userID)
        ->exec();
    return 'success';
}

/**
 * Get user `deviceToken` and `deviceType`.
 *
 * @param  int|array  $receivers
 * @access public
 * @return array
 */
public function getDeviceInfo($receivers = 0)
{
    return $this->dao->select('id,clientStatus,deviceToken,deviceType')->from(TABLE_USER)->where('id')->in($receivers)->fetchAll('id');
}
