<?php
/**
 * The control file of misc module of XXB.
 *
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd., www.zentao.net)
 * @license     ZOSL (https://zpl.pub/page/zoslv1.html)
 * @author      Chunsheng Wang <chunsheng@cnezsoft.com>
 * @package     misc
 * @version     $Id: control.php 4150 2016-10-17 08:06:43Z liugang $
 * @link        https://xuanim.com
 */
class misc extends control
{
    /**
     * keep logon function.
     *
     * @param  string $notice
     * @access public
     * @return void
     */
    public function ping($notice = '')
    {
        /* Save online status. */
        $this->loadModel('user')->online();

        /* Get notices. */
        if($this->app->user->account != 'guest')
        {
            $notices = $this->loadModel('action')->getUnreadNotice('', $skipNotice = $notice);

            $res = new stdclass();
            $res->time    = helper::now();
            $res->notices = $notices;
            die(json_encode($res));
        }
    }

    /**
     * Show about info of zentao.
     *
     * @access public
     * @return void
     */
    public function about()
    {
        die($this->display());
    }

    /**
     * Support PATH_INFO or not.
     *
     * @access public
     * @return void
     */
    public function pathinfo()
    {
        die('pathinfo');
    }

    /**
     * ignoreNotice
     *
     * @param  string $version
     * @access public
     * @return void
     */
    public function ignoreNotice($version)
    {
        $ignore = isset($config->ignoreNotice) ? json_decode($config->ignoreNotice) : array();
        $ignore[] = strip_tags(trim($version));
        $this->loadModel('setting')->setItem('system.sys.common.global.ignoreNotice', json_encode($ignore));
        die('success');
    }
}
