<?php
/**
 * The index view file of index module of XXB.
 *
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd., www.zentao.net)
 * @license     ZOSL (https://zpl.pub/page/zoslv1.html)
 * @author      Yidong Wang <yidong@cnezsoft.com>
 * @package     index
 * @version     $Id: index.html.php 4205 2016-10-24 08:19:13Z liugang $
 * @link        https://xuanim.com
 */
include "../../common/view/header.html.php";
include "../../common/view/version.html.php";
include "../../common/view/dashboard.html.php";
?>
<?php js::set('currentVersion', !empty($currentVersion) ? $currentVersion->version : '0.0.0');?>
<?php js::set('versionApiUrl', $versionApiUrl);?>
<?php js::set('userAccount', $this->app->user->account);?>
<?php if($isSuper && $enableDetachedConference):?>
  <div id="upgradeTips" class="alert alert alert-warning alert-dismissable hidden">
    <button id="closeUpgradeTips" type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
    <div>
      <i class="icon icon-bullhorn" style="display: inline-block"></i> <p style="display: inline-block"><?php echo $lang->upgradeBillboard->detachedConference;?></p>
    </div>
  </div>
<?php endif;?>
<div id='dashboardWrapper'>
  <div class='panels-container dashboard' id='dashboard' data-confirm-remove-block='<?php echo $lang->block->confirmRemoveBlock;?>'>
    <div class='row'>
      <?php foreach($blocks as $key => $block):?>
      <div class='col-xs-<?php echo $block->grid;?> pull-left'>
        <div class='panel' id='block<?php echo $block->id;?>' data-id='<?php echo $key;?>' data-blockid='<?php echo $block->id?>' data-name='<?php echo $block->title?>' data-url='<?php echo $block->blockLink;?>' <?php if(!empty($block->height)) echo "data-height='$block->height'";?>>
          <div class='panel-heading'>
            <div class='panel-actions'>
              <button class="btn btn-mini refresh-panel" type='button'><i class="icon-repeat"></i></button>
            </div>
            <?php echo $block->title?>
          </div>
          <div class='panel-body no-padding'></div>
        </div>
      </div>
      <?php endforeach;?>
    </div>
  </div>
</div>
<div id='noticeBox'>
  <div id="noticeGoUpgrade" class="alert alert-success with-icon alert-dismissable">
    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">x</button>
    <i class="icon icon-flag"></i>
    <div class="content">
      <p>
        <?php echo $lang->client->xxcNotice;?>&nbsp;<small class='text-danger version'></small>
        <?php echo html::a(helper::createLink('client', 'checkUpgrade'), $lang->client->goUpdate . '<i class="icon icon-double-angle-right"></i>', 'class="small"');?>
      </p>
    </div>
  </div>
</div>
<script>
  var isReadUpgradeTips = localStorage.getItem(v.userAccount + '-upgradeTips');
  if(!isReadUpgradeTips) $('#upgradeTips').toggleClass('hidden');
  $('#closeUpgradeTips').on('click', function()
  {
    localStorage.setItem(v.userAccount + '-upgradeTips', 'true');
  });
</script>
<?php include "../../common/view/footer.html.php"; ?>
