<?php include '../../common/view/header.html.php'; ?>
<div class='row'>
  <div class='col-md-12'>
    <div class='clearfix'>
      <div class='panel'>
        <div class="panel-heading">
          <strong><?php echo $lang->ldap->common; ?></strong>
        </div>
        <form method='post' id="ajaxForm" class='form-ajax echo <?php if ($enabled) echo 'ldap-enabled'; ?>'>
          <table class='table table-form'>
            <tr>
              <th><?php echo $lang->ldap->turnon ?></th>
              <td>
                <?php if ($type == 'edit') : ?>
                  <div class="checkbox-primary">
                    <input type="checkbox" name="enabled" id='enabled' value="true" <?php if ($enabled) echo 'checked'; ?> <?php if ($type != 'edit') echo 'disabled'; ?>>
                    <label for='enabled'><?php echo $lang->ldap->enabled; ?></label>
                  </div>
                <?php else : ?>
                  <div class="checkbox-primary disabled <?php if ($enabled) echo 'checked'; ?>">
                    <label><?php echo $lang->ldap->enabled; ?></label>
                  </div>
                <?php endif; ?>
              </td>
              <td></td>
            </tr>
            <tr class="ldap-row">
              <th><?php echo $lang->ldap->host ?></th>
              <td>
                <?php if ($type == 'edit') : ?>
                  <div class='required required-wrapper'></div>
                  <?php echo html::input('host', $host, "class='form-control' autocomplete='off'"); ?>
                <?php else : ?>
                  <?php echo $host; ?>
                <?php endif; ?>
              </td>
              <td><?php if ($type == 'edit') echo $lang->ldap->example . 'test.com' ?></td>
            </tr>
            <tr class="ldap-row">
              <th><?php echo $lang->ldap->port ?></th>
              <td>
                <?php if ($type == 'edit') : ?>
                  <div class='required required-wrapper'></div>
                  <?php echo html::input('port', $port, "class='form-control' autocomplete='off'"); ?>
                <?php else : ?>
                  <?php echo $port; ?>
                <?php endif; ?>
              </td>
              <td></td>
            </tr>
            <tr class="ldap-row">
              <th><?php echo $lang->ldap->version ?></th>
              <td>
                <?php if ($type == 'edit') : ?>
                  <div class='required required-wrapper'></div>
                  <?php echo html::select('version', $lang->ldap->versionList, $version, "class='form-control'"); ?>
                <?php else : ?>
                  <?php echo $version; ?>
                <?php endif; ?>
              </td>
              <td></td>
            </tr>
            <tr class="ldap-row">
              <th><?php echo $lang->ldap->admin; ?></th>
              <td>
                <?php if ($type == 'edit') : ?>
                  <div class='required required-wrapper'></div>
                  <?php echo html::input('admin', $admin, "class='form-control' autocomplete='off'"); ?>
                <?php else : ?>
                  <?php echo $admin; ?>
                <?php endif; ?>
              </td>
              <td><?php if ($type == 'edit') echo $lang->ldap->example . 'cn=admin,dc=test,dc=com' . $lang->ldap->or . 'admin@test.com'; ?></td>
            </tr>
            <?php if ($type == 'edit') : ?>
              <tr class="ldap-row">
                <th><?php echo $lang->ldap->password ?></th>
                <td>
                  <div class='required required-wrapper'></div>
                  <input type='password' style="display:none"> <!-- for disable autocomplete all browser -->
                  <?php echo html::password('password', $password, "class='form-control' autocomplete='off'"); ?>
                </td>
                <td></td>
              </tr>
            <?php endif; ?>
            <tr class="ldap-row">
              <th><?php echo $lang->ldap->baseDN ?></th>
              <td>
                <?php if ($type == 'edit') : ?>
                  <div class='required required-wrapper'></div>
                  <?php echo html::input('baseDN', $baseDN, "class='form-control' autocomplete='off'"); ?>
                <?php else : ?>
                  <?php echo $baseDN; ?>
                <?php endif; ?>
              </td>
              <td><?php if ($type == 'edit') echo $lang->ldap->example . 'dc=test,dc=com'; ?></td>
            </tr>
            <tr class="ldap-row">
              <th><?php echo $lang->ldap->charset ?></th>
              <td>
                <?php if ($type == 'edit') : ?>
                  <div class='required required-wrapper'></div>
                  <?php echo html::input('charset', $charset, "class='form-control' autocomplete='off'"); ?>
                <?php else : ?>
                  <?php echo $charset; ?>
                <?php endif; ?>
              </td>
              <td></td>
            </tr>
            <tr class="ldap-row">
              <th><?php echo $lang->ldap->account; ?></th>
              <td>
                <?php if ($type == 'edit') : ?>
                  <div class='required required-wrapper'></div>
                  <?php echo html::input('account', $account, "class='form-control' autocomplete='off'"); ?>
                <?php else : ?>
                  <?php echo $account; ?>
                <?php endif; ?>
              </td>
              <td><?php if ($type == 'edit') echo $lang->ldap->accountPS ?></td>
            </tr>
            <tr class="ldap-row">
              <th><?php echo $lang->ldap->displayName; ?></th>
              <td>
                <?php if ($type == 'edit') : ?>
                  <div class='required required-wrapper'></div>
                  <?php echo html::input('displayName', $displayName, "class='form-control' autocomplete='off'"); ?>
                <?php else : ?>
                  <?php echo $displayName; ?>
                <?php endif; ?>
              </td>
              <td><?php if ($type == 'edit') echo $lang->ldap->displayNamePS ?></td>
            </tr>
            <tr class="ldap-row">
              <th><?php echo $lang->ldap->autoCreate; ?></th>
              <td>
                <?php echo $type == 'edit'
                  ? html::radio('autoCreate', $lang->ldap->autoCreateList, $autoCreate)
                  : $lang->ldap->autoCreateList[$autoCreate];
                ?>
              </td>
              <td><?php if ($type == 'edit') echo $lang->ldap->autoCreatePS ?></td>
            </tr>
            <tr>
              <td></td>
              <td>
                <?php echo $type == 'edit' ? html::submitButton() : html::linkButton($lang->edit, helper::createLink('ldap', 'index', 'type=edit'), 'btn btn-primary'); ?>
              </td>
              <td></td>
            </tr>
          </table>
        </form>
      </div>
    </div>
  </div>
</div>
<style>
  .ldap-row {
    display: none
  }

  #ajaxForm.ldap-enabled .ldap-row {
    display: table-row
  }
</style>
<script>
  $(function() {
    $.setAjaxForm('#ajaxForm');
    $('#enabled').on('change', function() {
      $('#ajaxForm').toggleClass('ldap-enabled', $('#enabled').is(':checked'));
    });
  });
</script>
<?php include '../../common/view/footer.html.php'; ?>