<?php

class device extends control
{
    /**
     * The construct method.
     *
     * @access public
     * @param string $moduleName
     * @param string $methodName
     * @param string $appName
     * @return void
     */
    public function __construct($moduleName = '', $methodName = '', $appName = '')
    {
        parent::__construct($moduleName, $methodName, $appName);
    }

    /**
     * Device browse page.
     *
     * @access public
     * @param string $orderBy
     * @param int $recTotal
     * @param int $recPerPage
     * @param int $pageID
     * @return void
     */
    public function browse($orderBy = 'lastLogin_desc', $recTotal = 0, $recPerPage = 10, $pageID = 1)
    {
        $this->app->loadClass('pager', $static = true);
        $pager = new pager($recTotal, $recPerPage, $pageID);
        $this->view->records = $this->device->getDeviceRecords($orderBy, $pager);
        $this->view->pager   = $pager;
        $this->view->orderBy = $orderBy;
        $this->display();
    }

    /**
     * remove auth token
     *
     * @access public
     * @param string $deviceID
     * @param string $deviceID
     * @return void
     */
    public function remove($deviceType, $deviceID)
    {
        if($this->loadModel('im')->userRevokeAuthToken($this->app->user->id, $deviceType, $deviceID))
        {
            $this->send(array('result' => 'success'));
        }
        $this->send(array('result' => 'fail', 'message' => dao::getError()));
    }
}
