<?php
class myBlock extends control
{
    /**
     * Get content when block is status
     *
     * @param  object    $block
     * @access public
     * @return string
     */
    public function printStatusBlock($blockID)
    {
        $block = $this->block->getByID($blockID);
        if(empty($block)) return false;

        $this->app->loadLang('client');

        $now             = helper::now();
        $polling         = empty($this->config->xuanxuan->pollingInterval) ? $this->lang->client->noData : $this->config->xuanxuan->pollingInterval . 's';
        $lastPoll        = $this->loadModel('setting')->getItem("owner=system&module=common&section=xxd&key=lastPoll");
        $xxdStatus       = $this->loadModel('im')->getXxdStatus();
        $onlineUserCount = $xxdStatus == 'offline' ? 0 : count($this->loadModel('im')->userGetList('online'));
        $setServerBtn    = html::a(helper::createLink('setting', 'xuanxuan', 'type=edit'), $this->lang->client->set, 'class="btn"');
        $xxdStartDate    = zget($this->config->xxd, 'start', $this->lang->client->noData);

        if(!empty($lastPoll) && $xxdStatus == 'online' && !empty($this->config->xxd) && $polling < 600)
        {
            $xxdRunTime = $xxdStartDate === $this->lang->client->noData ? $this->lang->client->noData : $this->im->getXxdRunTime(strtotime($now) - strtotime($xxdStartDate));
            $xxdRunHtml = "<div class='col date' style='height:100px;padding-top:20px;width:50%;'><p>{$this->lang->client->xxdRunTime}</p><h2>{$xxdRunTime}</h2></div>";
        }
        else
        {
            $xxdRunHtml = "<div class='col date' style='height:100px;padding-top:20px;width:50%;'><p>{$this->lang->client->xxdStartDate}</p><h2>{$xxdStartDate}</h2></div>";
        }

        $html  = '<div class="table-row statusBlock">';
        $html  = '<div class="pull-left" style="width:70%;text-align:center;">';
        $html .= "<div class='col date' style='height:100px;padding-top:20px;width:50%;'><p>{$this->lang->client->xxdStatus}</p><h2>{$this->lang->client->xxdStatusList[$xxdStatus]}</h2></div>";
        $html .= $xxdRunHtml;
        $html .= "<div class='col' style='height:100px;padding-top:20px;width:50%;'><p>{$this->lang->client->polling}</p><h2>{$polling}</h2></div>";
        $html .= "<div class='col' style='height:100px;padding-top:20px;width:50%;'><p>{$this->lang->client->countUsers}</p><h2>{$onlineUserCount}</h2></div>";
        $html .= "</div>";
        $html .= "<div class='col server' style='height:200px;width:30%;text-align:center;padding-top:56px;'><p>{$this->lang->client->setServer}</p><h2>{$setServerBtn}</h2></div>";
        $html .= '</div>';

        die($html);
    }
}
