<?php
/**
 * The control file of groupsetting module of XXB.
 *
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd., www.zentao.net)
 * @license     ZOSL (https://zpl.pub/page/zoslv1.html)
 * @author      Deqing Chai <chaideqing@cnezsoft.com>
 * @package     groupsetting
 * @version     $Id$
 * @link        https://xuanim.com
 */
?>
<?php
class groupsetting extends control
{
    /**
     * View and set groupsetting.
     *
     * @access public
     * @param  string $type
     * @return void
     */
    public function admin($type = '')
    {
        if(!empty($_POST))
        {
            $setting = fixer::input('post')->get();
            $result  = $this->loadModel('setting')->setItems('system.common.xuanxuan', $setting);
            if(!$result)
            {
                $this->send(array('result' => 'fail', 'message' => dao::getError()));
            }
            $this->send(array('result' => 'success', 'message' => $this->lang->saveSuccess, 'locate' => inlink('admin')));
        }

        $conferenceConfig = $this->loadModel('conference')->getConfiguration();

        $this->view->title            = $this->lang->setting->param;
        $this->view->server           = $this->loadModel('im')->getServer();
        $this->view->path             = $this->app->basePath;
        $this->view->type             = $type;
        $this->view->enableConference = isset($conferenceConfig->enabled) && $conferenceConfig->enabled == 'true';

        $this->display();
    }
}
