<?php
/**
 * The zentaoAdmin view of entry module of XXB.
 *
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd., www.zentao.net)
 * @license     ZOSL (https://zpl.pub/page/zoslv1.html)
 * @author      Tingting Dai <daitingting@xirangit.com>
 * @package     entry
 * @version     $Id$
 * @link        https://xuanim.com
 */
include '../../common/view/header.html.php';?>
<div class='panel'>
  <div class='panel-heading'>
    <strong><i class='icon-link'></i> <?php echo $lang->entry->bindUser;?></strong>
  </div>
  <div class='panel-body'>
    <form method='post' class='form' id='entryForm'>
      <table class='table table-form w-p60'>
        <tr>
          <td>
            <div class='input-group'>
              <span class='input-group-addon'><?php echo $lang->entry->adminAccount;?></span>
              <?php echo html::input('account', '', "class='form-control'")?>
              <span class='input-group-addon'><?php echo $lang->entry->adminPassword;?></span>
              <?php echo html::password('password', '', "class='form-control'")?>
            </div>
          </td>
          <td><?php echo html::submitButton($lang->entry->nextStep);?></td>
        </tr>
      </table>
    </form>
  </div>
</div>
<?php include '../../common/view/footer.html.php';?>
