<?php
/**
 * The html template file of index method of install module of XXB.
 *
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd., www.zentao.net)
 * @license     ZOSL (https://zpl.pub/page/zoslv1.html)
 * @author      Chunsheng Wang <chunsheng@cnezsoft.com>
 * @package     install
 * @version     $Id: index.html.php 4029 2016-08-26 06:50:41Z liugang $
 * @link        https://xuanim.com
 */
?>
<?php include '../../common/view/header.lite.html.php';?>
<div class='container'>
  <div class='modal-dialog'>
    <div class='modal-content'>
      <div class="modal-header text-right"><div class='btn dropdown'><?php include '../../common/view/selectlang.html.php';?></div></div>
      <div class='modal-body'>
        <h3><?php echo $lang->install->welcome;?></h3>
        <div><?php printf(nl2br(trim($lang->install->desc)), $config->version);?></div>
      </div>
      <div class='modal-footer'>
        <?php if(!isset($latestRelease)):?>
        <p class='text-center'><?php echo html::a($this->createLink('install', 'step0'), $lang->install->start, "class='btn btn-primary btn-install'");?></p>
        <?php else:?>
        <?php vprintf($lang->install->newReleased, $latestRelease);?>
        <p>
          <?php
          echo $lang->install->choice;
          echo html::a($latestRelease->url, $lang->install->seeLatestRelease, "target='_blank'");
          echo html::a($this->createLink('install', 'step0'), $lang->install->keepInstalling, "class='btn btn-primary btn-install'");
          ?>
        </p>
        <?php endif;?>
      </div>
    </div>
  </div>
</div>
<?php include './footer.html.php';?>
