<?php
/**
 * The model file of help module of XXB.
 *
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd., www.zentao.net)
 * @license     ZOSL (https://zpl.pub/page/zoslv1.html)
 * @author      Hao Sun <sunhao@cnezsoft.com>
 * @package     help
 * @version     $Id: model.php 4145 2016-10-14 05:31:16Z liugang $
 * @link        https://xuanim.com
 */
?>
<?php
class helpModel extends model
{
    /**
     * Get server IP address
     *
     * @access public
     * @return string
     */
    public function getServerIP()
    {
        $ip = '';
        if(isset($_SERVER))
        {
            if($_SERVER['SERVER_ADDR'])
            {
                $ip = $_SERVER['SERVER_ADDR'];
            }
            else
            {
                $ip = $_SERVER['LOCAL_ADDR'];
            }
        }
        else
        {
            $ip = getenv('SERVER_ADDR');
        }
        return $ip;
    }

    /**
     * Get server adapter data
     *
     * @access public
     * @return string
     */
    public function getServerData()
    {
        if(!function_exists('ioncube_server_data')) return '';
        return ioncube_server_data();
    }
}
