<?php
/**
 * The edit admin view file of user module of XXB.
 *
 * @copyright   Copyright 2009-2020 青岛易软天创网络科技有限公司(QingDao Nature Easy Soft Network Technology Co,LTD, www.cnezsoft.com)
 * @license     ZOSL (https://zpl.pub/page/zoslv1.html)
 * @author      Chunsheng Wang <chunsheng@cnezsoft.com>
 * @package     user
 * @version     $Id: edit.admin.html.php 4029 2016-08-26 06:50:41Z liugang $
 * @link        https://xuanim.com
 */
?>
<?php include '../../common/view/header.html.php';?>
<?php include '../../common/view/treeview.html.php';?>
<div class="col-md-12">
  <div class='row'>
    <?php include './deptside.html.php';?>
    <div class='col-md-10'>
      <div class="panel">
        <div class="panel-heading"><strong><i class="icon-edit"></i> <?php echo $lang->user->editProfile;?></strong></div>
        <form method='post' id='ajaxForm' class='panel-body'>
          <table class='table table-form'>
            <caption><?php echo $lang->user->basicInfo; ?></caption>
            <tbody>
              <tr>
                <th class='w-100px'><?php echo $lang->user->account;?></th>
                <td class='w-p40'><?php echo html::input('account', $user->account, "class='form-control disabled' disabled='disabled'");?></td>
                <?php if($this->app->user->admin == 'super'){?>
                  <th class='w-100px'><?php echo $lang->user->super;?></th>
                  <td class='w-p40'><input name='admin' type='checkbox' value='super' <?php if($user->admin == 'super') echo 'checked';?>></td>
                  <?php }else{?>
                    <th class='w-100px'></th>
                    <td class='w-p40'></td>
                  <?php }?>
              </tr>
              <tr>
                <th class='w-100px'><?php echo $lang->user->realname;?></th>
                <td><?php echo html::input('realname', $user->realname, "class='form-control'");?></td>
                <th class='w-100px'><?php echo $lang->user->gender;?></th>
                <td><?php unset($lang->user->genderList->u); echo html::radio('gender', $lang->user->genderList, $user->gender);?></td>
              </tr>
              <tr>
                <th class='w-100px'><?php echo $lang->user->dept;?></th>
                <td><?php echo html::select('dept', $depts, $user->dept, "class='form-control'");?></td>
                <th><?php echo $lang->user->role;?></th>
                <td><?php echo html::select('role', $lang->user->roleList, $user->role, "class='form-control'");?></td>
              </tr>
              <tr>
                <th><?php echo $lang->user->password;?></th>
                <td><?php echo html::password('password1', '', "class='form-control' autocomplete='off'")?></td>
                <th><?php echo $lang->user->password2;?></th>
                <td><?php echo html::password('password2', '', "class='form-control'");?></td>
              </tr>
            </tbody>
          </table>
          <table class='table table-form'>
            <caption><?php echo $lang->user->contactInfo; ?></caption>
            <tbody>
              <tr>
                <th class='w-100px'><?php echo $lang->user->email;?></th>
                <td class='w-p40'><?php echo html::input('email', $user->email, "class='form-control'");?></td>
                <th class='w-100px'><?php echo $lang->user->zipcode;?></th>
                <td><?php echo html::input('zipcode', $user->zipcode, "class='form-control'");?></td>
              </tr>
              <tr>
                <th class='w-100px'><?php echo $lang->user->mobile;?></th>
                <td class='w-p40'><?php echo html::input('mobile', $user->mobile, "class='form-control'");?></td>
                <th><?php echo $lang->user->phone;?></th>
                <td><?php echo html::input('phone', $user->phone, "class='form-control'");?></td>
              </tr>
              <tr>
                <th class='w-100px'><?php echo $lang->user->qq;?></th>
                <td class='w-p40'><?php echo html::input('qq', $user->qq, "class='form-control'");?></td>
                <th class='w-100px'><?php echo $lang->user->weixin;?></th>
                <td><?php echo html::input('weixin', $user->weixin, "class='form-control'");?></td>
              </tr>
              <tr>
                <th class='w-100px'><?php echo $lang->user->address;?></th>
                <td colspan='3'><?php echo html::input('address', $user->address, "class='form-control'");?></td>
              </tr>
            </tbody>
            <tfoot>
              <tr><td class='w-100px'></td><td><?php echo html::submitButton();?></td></tr>
            </tfoot>
          </table>
        </form>
      </div>
    </div>
  </div>
</div>
<?php include '../../common/view/footer.html.php';?>
