<?php
/**
 * Get version of xuanxuan.
 *
 * @access public
 * @return string
 */
public function getXuanxuanVersion()
{
    return !empty($this->config->xuanxuan->global->version) ? $this->config->xuanxuan->global->version : '1.0';
}

/**
 * Upgrade xuanxuan.
 *
 * @param  string $fromVersion
 * @access public
 * @return void
 */
public function upgradeXuanxuan($fromVersion)
{
    switch($fromVersion)
    {
        case '1.0'   : $this->execSQL($this->getUpgradeFile('xuanxuan1.0'));
        case '1.1.0' :
        case '1.1.1' : $this->execSQL($this->getUpgradeFile('xuanxuan1.1.1'));
        case '1.3.0' : $this->execSQL($this->getUpgradeFile('xuanxuan1.3.0'));
        case '1.4.0' : $this->execSQL($this->getUpgradeFile('xuanxuan1.4.0'));
            $this->processMessageStatus();
        case '1.5.0' :
        case '1.6.0' : $this->execSQL($this->getUpgradeFile('xuanxuan1.6.0'));
        case '2.0.0' : $this->execSQL($this->getUpgradeFile('xuanxuan2.0.0'));
        case '2.1.0' : $this->execSQL($this->getUpgradeFile('xuanxuan2.1.0'));
        case '2.2.0' :
            $this->processUserStatus();
            $this->processXuanxuanKey();
        case '2.3.0' : $this->execSQL($this->getUpgradeFile('xuanxuan2.3.0'));
        case '2.4.0' : $this->execSQL($this->getUpgradeFile('xuanxuan2.4.0'));
            $this->changeMessageStatusTable();
        case '2.5.0' : $this->execSQL($this->getUpgradeFile('xuanxuan2.5.0'));
        case '2.5.1' :
        case '2.5.2' :
        case '2.5.3' :
        case '2.5.4' :
        case '2.5.5' :
        case '2.5.6' :
        case '2.5.7' : $this->execSQL($this->getUpgradeFile('xuanxuan2.5.7'));
        case '3.0.0-beta.1' : $this->execSQL($this->getUpgradeFile('xuanxuan3.0.0-beta.1'));
        case '3.0 beta2'    :
        case '3.0-beta3'    : $this->execSQL($this->getUpgradeFile('xuanxuan3.0-beta3'));
        case '3.0.beta4'    :
        case '3.0'          :
        case '3.1'          :
        case '3.1.1'        : $this->execSQL($this->getUpgradeFile('xuanxuan3.1.1'));
        case '3.2'          :
        case '3.2.1'        :
        case '3.2.2'        :
        case '3.2.3'        : $this->execSQL($this->getUpgradeFile('xuanxuan3.2.3'));
        case '3.3'          :
            $this->execSQL($this->getUpgradeFile('xuanxuan3.3'));
            $this->updateLastMessage();
            $this->updateUserDevice();
        case '4.0.beta1'    :
        case '4.0.beta2'    : $this->execSQL($this->getUpgradeFile('xuanxuan4.0.beta2'));
        case '4.0.beta3'    :
            $this->execSQL($this->getUpgradeFile('xuanxuan4.0.beta3'));
            $this->dropOrderFromMessagePartitions();
        case '4.0'          : $this->execSQL($this->getUpgradeFile('xuanxuan4.0'));
        case '4.1.beta'     :
        case '4.1'          :
        case '4.2'          : $this->execSQL($this->getUpgradeFile('xuanxuan4.2'));
        case '4.3'          :
        case '4.4'          : $this->execSQL($this->getUpgradeFile('xuanxuan4.4'));
        case '4.4.1'        :
        case '4.5.beta1'    :
        case '4.5'          :
        case '4.6'          : $this->execSQL($this->getUpgradeFile('xuanxuan4.6'));
        case '4.7'          :
        case '5.0'          :
        case '5.1'          : $this->execSQL($this->getUpgradeFile('xuanxuan5.1'));
        case '5.2'          :
        default : $this->loadModel('setting')->setItem('system.xuanxuan.global.version', isset($this->config->product) && $this->config->product == 'xxb' ? $this->config->version : $this->config->xuanxuan->version);
    }
}

/**
 * Change status of table user to clientStatus.
 *
 * @access public
 * @return bool
 */
public function processUserStatus()
{
    $hasStatus       = false;
    $hasClientStatus = false;

    $fields = $this->dbh->query('DESC ' . TABLE_USER)->fetchAll();
    foreach($fields as $field)
    {
        if($field->Field == 'status')       $hasStatus = true;
        if($field->Field == 'clientStatus') $hasClientStatus = true;
    }

    if($hasStatus && !$hasClientStatus)
    {
        try
        {
            $this->dbh->exec('ALTER TABLE ' . TABLE_USER . "CHANGE `status` `clientStatus` enum('online', 'away', 'busy', 'offline') NOT NULL DEFAULT 'offline'");
        }
        catch (PDOException $e)
        {
            return false;
        }
    }

    return true;
}

/**
 * Process message status.
 *
 * @access public
 * @return bool
 */
public function processMessageStatus()
{
    $table = $this->dbh->query("SHOW TABLES LIKE '{$this->config->db->prefix}im_usermessage'")->fetch();
    if(empty($table)) return false;

    $userMessages = array();
    $messagesList = $this->dao->select('*')->from($this->config->db->prefix . 'im_usermessage')->fetchAll();
    foreach($messagesList as $messages)
    {
        $user     = $messages->user;
        $messages = json_decode($messages->message);
        foreach($messages as $message)
        {
            if(isset($userMessages[$user][$message->gid])) continue;

            $data = new stdClass();
            $data->user   = $user;
            $data->gid    = $message->gid;
            $data->status = 'waiting';
            $this->dao->insert(TABLE_IM_MESSAGESTATUS)->data($data)->exec();

            $userMessages[$user][$message->gid] = $message->gid;
        }
    }

    return !dao::isError();
}

/**
 * Process key of xuanxuan.
 *
 * @access public
 * @return bool
 */
public function processXuanxuanKey()
{
    $this->loadModel('setting')->setItem('system.common.xuanxuan.key', $this->config->xuanxuan->key);
    $this->setting->deleteItems('owner=system&module=xuanxuan&key=key');
    return !dao::isError();
}

/**
 * Fix the history and Change messagestatus table.
 * @return bool
 */
public function changeMessageStatusTable()
{
    $prefix     = $this->config->db->prefix;
    $errorTable = $this->dbh->query("show tables like '{$prefix}im_messsagestatus'")->fetch();
    if(!empty($errorTable)) $this->dbh->query("RENAME TABLE `{$prefix}im_messsagestatus` TO `{$prefix}im_messagestatus`");
    $needUpdate = false;
    $fields = $this->dbh->query('DESC ' . TABLE_IM_MESSAGESTATUS)->fetchAll();
    foreach($fields as $field)
    {
        if($field->Field == 'gid')
        {
            $needUpdate = true;
            break;
        }
    }
    if(!$needUpdate) return false;

    $gids = $this->dao->select('gid')->from(TABLE_IM_MESSAGESTATUS)->where('status')->ne('sent')->fetchPairs('gid');
    if(!empty($gids))
    {
        $messages = $this->dao->select('gid, id')->from(TABLE_IM_MESSAGE)->where('gid')->in($gids)->fetchPairs();
        foreach($messages as $gid => $message)
        {
            $this->dao->update(TABLE_IM_MESSAGESTATUS)->set('message')->eq($message)->where('gid')->eq($gid)->exec();
        }
    }
    $this->dao->delete()->from(TABLE_IM_MESSAGESTATUS)->where('status')->eq('sent')->exec();

    $userIndex = $this->dbh->query("show index from " . TABLE_IM_MESSAGESTATUS . " where Key_name = 'user'")->fetch();
    if($userIndex) $this->dbh->exec('ALTER TABLE ' . TABLE_IM_MESSAGESTATUS . ' DROP INDEX `user`;');
    $this->dbh->exec('ALTER TABLE ' . TABLE_IM_MESSAGESTATUS . ' DROP `gid`;');
    $this->dbh->exec('ALTER TABLE ' . TABLE_IM_MESSAGESTATUS . ' ADD UNIQUE INDEX `user` (`user`, `message`);');
    return !dao::isError();
}

/**
 * Update lastMessage of im_chat table.
 *
 * @access public
 * @return bool
 */
public function updateLastMessage()
{
    $prefix = $this->config->db->prefix;
    $lastMessageData = array();
    $lastMessages = $this->dbh->query("SELECT MAX({$prefix}im_message.id),{$prefix}im_chat.id FROM {$prefix}im_message LEFT JOIN {$prefix}im_chat ON {$prefix}im_message.cgid = {$prefix}im_chat.gid GROUP BY {$prefix}im_chat.gid;")->fetchAll();
    if(empty($lastMessages)) return true;
    foreach($lastMessages as $lastMessage)
    {
        $cid = $lastMessage->id;
        $mid = $lastMessage->{"MAX({$prefix}im_message.id)"};
        if(empty($cid) || empty($mid)) continue;
        $lastMessageData[] = "($cid,$mid)";
    }
    if(empty($lastMessageData)) return true;
    $query = "INSERT INTO `{$prefix}im_chat` (`id`,`lastMessage`) VALUES " . join(',', $lastMessageData) . " ON DUPLICATE KEY UPDATE `lastMessage`=VALUES(`lastMessage`)";
    $this->dbh->query($query);
    return !dao::isError();
}

/**
 * Move data into im_userdevice table.
 *
 * @access public
 * @return bool
 */
public function updateUserDevice()
{
    $prefix = $this->config->db->prefix;
    $userDeviceData = array();
    $userDevices = $this->dbh->query("SELECT " . TABLE_CONFIG . ".`value`," . TABLE_USER . ".`id` FROM " . TABLE_CONFIG . " LEFT JOIN " . TABLE_USER . " ON " . TABLE_CONFIG . ".`owner` = " . TABLE_USER . ".`account` WHERE " . TABLE_CONFIG . ".`section` = 'lastLogin' AND " . TABLE_CONFIG . ".`key` = 'desktop' GROUP BY " . TABLE_CONFIG . ".`owner`;")->fetchAll();
    if(empty($userDevices)) return true;
    foreach($userDevices as $userDevice)
    {
        $user      = $userDevice->id;
        $lastLogin = $userDevice->value;
        if(empty($user) || empty($lastLogin)) continue;
        $userDeviceData[] = "($user,'$lastLogin','$lastLogin')";
    }
    if(empty($userDeviceData)) return true;
    $query = "INSERT INTO `{$prefix}im_userdevice` (`user`,`lastLogin`,`lastLogout`) VALUES " . join(',', $userDeviceData);
    $this->dbh->query($query);
    $this->dbh->query("DELETE FROM " . TABLE_CONFIG . " WHERE `section` = 'lastLogin';");
    return !dao::isError();
}

/**
 * Drop order column from all message partition tables.
 *
 * @access public
 * @return bool
 */
public function dropOrderFromMessagePartitions()
{
    $tables = $this->dbh->query("SHOW TABLES LIKE '{$this->config->db->prefix}im_message\_%'")->fetchAll();
    $tables = array_filter(array_map(function($table) {
        $tableName = current(array_values((array)$table));
        if(!preg_match("/{$this->config->db->prefix}im_message_[a-z]+/", $tableName)) return $tableName;
    }, $tables));

    if(empty($tables)) return true;

    $query = '';
    foreach($tables as $table)
    {
        $query .= "ALTER TABLE `$table` DROP COLUMN `order`;";
    }
    $this->dbh->query($query);
    return !dao::isError();
}
