<?php
class setting extends control
{
    /**
     * Configuration of xuanxuan.
     *
     * @param  string $type
     * @access public
     * @return void
     */
    public function xuanxuan($type = '')
    {
        if($type != 'edit' && empty($this->config->xuanxuan->server)) $this->locate(inlink('xuanxuan', 'type=edit'));
        if($type != 'edit' && (!zget($this->config->xuanxuan, 'key', '') or zget($this->config->xuanxuan, 'key', '') == str_repeat(8, 32))) $this->locate(inlink('xuanxuan', 'type=edit'));

        $this->app->loadLang('im');
        if($_POST)
        {
            $errors  = array();
            $setting = fixer::input('post')->get();

            if(strlen($this->post->key) != 32 or !validater::checkREG($this->post->key, '|^[A-Za-z0-9]+$|')) $errors['key'] = $this->lang->im->errorKey;
            if($this->post->key == str_repeat(8, 32)) $errors['key'] = $this->lang->im->defaultKey;

            if($setting->https == 'on')
            {
                if(empty($setting->sslcrt)) $errors['sslcrt'] = $this->lang->im->errorSSLCrt;
                if(empty($setting->sslkey)) $errors['sslkey'] = $this->lang->im->errorSSLKey;
            }

            if(strpos($setting->server, '127.0.0.1') !== false) $errors['server'][] = $this->lang->im->xxdServerError;
            if(strpos($setting->server, 'https://') !== 0 and strpos($setting->server, 'http://') !== 0) $errors['server'][] = $this->lang->im->xxdSchemeError;
            if(empty($setting->server)) $errors['server'][] = $this->lang->im->xxdServerEmpty;

            /* Check if value is a valid positive number. (float or int) */
            if(!is_numeric($setting->uploadFileSize) || (int)$setting->uploadFileSize < 0) $errors['uploadFileSize'] = $this->lang->im->xxdFileSizeErr;

            /* Check if value is a valid positive int. */
            if(!(is_numeric($setting->chatPort) && is_int($setting->chatPort + 0)) || (int)$setting->chatPort <= 0 || (int)$setting->chatPort > 65535) $errors['chatPort'] = $this->lang->im->xxdPortError;
            if(!(is_numeric($setting->commonPort) && is_int($setting->commonPort + 0)) || (int)$setting->commonPort <= 0 || (int)$setting->commonPort > 65535) $errors['commonPort'] = $this->lang->im->xxdPortError;
            if(!(is_numeric($setting->pollingInterval) && is_int($setting->pollingInterval + 0)) || (int)$setting->pollingInterval < 5) $errors['pollingInterval'] = $this->lang->im->xxdPollIntErr;
            if(!(is_numeric($setting->tokenLifetime) && is_int($setting->tokenLifetime  + 0)) || (int)$setting->tokenLifetime < 1) $errors['tokenLifetime'] = $this->lang->im->tokenLifetimeErr;
            if(!(is_numeric($setting->tokenAuthWindow) && is_int($setting->tokenAuthWindow  + 0)) || (int)$setting->tokenAuthWindow < 20) $errors['tokenAuthWindow'] = $this->lang->im->tokenAuthWindowErr;

            $comment = json_encode($_POST);
            if($errors)
            {
                $this->setting->addSettingAction('paramProfile', 0, 'edit', 'fail', $comment);
                $this->send(array('result' => 'fail', 'message' => $errors));
            }

            $result = $this->loadModel('setting')->setItems('system.common.xuanxuan', $setting);
            if(!$result)
            {
                $this->setting->addSettingAction('paramProfile', 0, 'edit', 'fail', $comment);
                $this->send(array('result' => 'fail', 'message' => dao::getError()));
            }
            $this->setting->addSettingAction('paramProfile', 0, 'edit', 'success', $comment);
            $this->send(array('result' => 'success', 'message' => $this->lang->saveSuccess, 'locate' => inlink('xuanxuan')));
        }

        $os = 'win';
        if(strpos(strtolower(PHP_OS), 'win') !== 0) $os = strtolower(PHP_OS);

        if(isset($this->lang->client->menu))
        {
            $this->lang->setting->menu = $this->lang->client->menu;
            $this->lang->menuGroups->setting = 'client';
        }

        $this->view->title   = $this->lang->setting->param;
        $this->view->type    = $type;
        $this->view->os      = $os . '_' . php_uname('m');
        $this->view->server  = $this->loadModel('im')->getServer();
        $this->view->path    = $this->app->basePath;
        $this->display();
    }
}
