<?php
/**
 * The admin view file of push module of XXB.
 *
 * @copyright   Copyright 2009-2020 青岛易软天创网络科技有限公司(QingDao Nature Easy Soft Network Technology Co,LTD, www.cnezsoft.com)
 * @license     ZOSL (https://zpl.pub/page/zoslv1.html)
 * @author      xuanxuan
 * @package     Push
 * @version     $Id:
 * @link        https://xuanim.com
 */
?>
<?php
include '../../common/view/header.html.php';
?>
<div class='page-content'>
  <ul class="nav nav-tabs">
    <?php foreach($this->config->push->pushTabList as $tabIndex):?>
    <li class="<?php if($type == $tabIndex) echo 'active';?>">
      <a href="<?php echo '#' . $tabIndex . 'Content'?>" data-toggle="tab"><?php echo $lang->push->$tabIndex;?></a>
    </li>
    <?php endforeach;?>
  </ul>
  <div class="tab-content">
    <div class="tab-pane fade <?php echo $type == 'all' ? 'active in' : '';?>" id="allContent">
      <form method='post' id='pushGlobal' class='form-ajax' action=<?php echo $this->createLink("push", 'admin', 'type=all');?>>
        <table class='table table-form'>
          <tr>
            <th class="w-100px"><?php echo $lang->push->enable;?></th>
            <td class="w-200px">
              <div class="checkbox">
                <label>
                  <input type="checkbox" name="enable" value='open' <?php if($enable == 'open') echo 'checked';?>> <?php echo $lang->push->openPush;?>
                </label>
              </div>
            </td>
            <td></td>
          </tr>
          <tr>
            <th class="w-100px"><?php echo $lang->push->privacyTitle;?></th>
            <td class="w-200px">
              <?php foreach($this->config->push->privacyLevelIDList as $levelID):?>
                <div class="radio">
                  <label>
                    <input type="radio" name="privacyLevel" value="<?php echo $levelID;?>" <?php if($levelID == $privacyLevel) echo 'checked';?>><?php echo $lang->push->privacyLevel[$levelID];?>
                  </label>
                </div>
              <?php endforeach;?>
            </td>
            <td></td>
          </tr>
          <tr>
            <th></th>
            <td colspan='2'>
              <?php echo html::submitButton();?>
            </td>
          </tr>
        </table>
      </form>
    </div>
    <div class="tab-pane fade <?php echo $type == 'android' ? 'active in' : '';?>" id="androidContent">
      <form method='post' id='ajaxForm' class='form-ajax' action=<?php echo $this->createLink("push", 'admin', 'type=android');?>>
        <table class='table table-form'>
          <tr>
            <th class="w-100px"><?php echo $lang->push->accessId;?></th>
            <td class="code <?php echo $androidConfig ? 'w-300px' : 'w-200px';?>">
              <?php echo $androidConfig ? $androidConfig->accessId : html::input('accessId', '', "class='form-control' placeholder='{$lang->push->placeholder->accessId}'");?>
            </td>
            <td class='text-muted'>&nbsp;&nbsp;<?php echo $lang->push->accessIdNote;?></td>
          </tr>
          <tr>
            <th><?php echo $lang->push->accessKey;?></th>
            <td class="code"><?php echo $androidConfig ? $androidConfig->accessKey : html::input('accessKey', '', "class='form-control' placeholder='{$lang->push->placeholder->accessKey}'");?></td>
            <td class='text-muted'>&nbsp;&nbsp;<?php echo $lang->push->accessKeyNote;?></td>
          </tr>
          <tr>
            <th><?php echo $lang->push->secretKey;?></th>
            <td class="code"><?php echo $androidConfig ? $androidConfig->secretKey : html::input('secretKey', '', "class='form-control' placeholder='{$lang->push->placeholder->secretKey}'");?></td>
            <td class='text-muted'>&nbsp;&nbsp;<?php echo $lang->push->secretKeyNote;?></td>
          </tr>
          <tr><th></th><td></td></tr>
          <tr>
            <th></th>
            <td>
              <?php echo $androidConfig ? '' : "<a href='https://console.cloud.tencent.com/tpns' target='_blank'>{$lang->push->goToGet}<i class='icon icon-double-angle-right'></i></a>";?>
            </td>
          </tr>
          <tr>
            <th></th>
            <td colspan='2'>
              <?php echo $androidConfig ? html::a($this->inlink('edit', 'type=android'), $lang->edit, "class='btn btn-primary' data-toggle='modal'") : html::submitButton();?>
            </td>
          </tr>
        </table>
      </form>
    </div>
    <div class="tab-pane fade <?php echo $type == 'ios' ? 'active in' : '';?>" id="iosContent">
      <form method='post' id='pushIos' class='form-ajax' action=<?php echo $this->createLink("push", 'admin', 'type=ios');?>>
        <table class='table table-form'>
          <tr>
            <th class="w-100px"><?php echo $lang->push->accessId;?></th>
            <td class="code <?php echo $iosConfig ? 'w-260px' : 'w-300px';?>">
              <?php echo $iosConfig ? $iosConfig->accessId : html::input('accessId', '', "class='form-control' placeholder='{$lang->push->placeholder->accessId}'");?>
            </td>
            <td class='text-muted'>&nbsp;&nbsp;<?php echo $lang->push->iOSIdNote;?></td>
          </tr>
          <tr>
            <th><?php echo $lang->push->accessKey;?></th>
            <td class='code'><?php echo $iosConfig ? $iosConfig->accessKey : html::input('accessKey', '', "class='form-control' placeholder='{$lang->push->placeholder->accessKey}'");?></td>
            <td class='text-muted'>&nbsp;&nbsp;<?php echo $lang->push->iOSKeyNote;?></td>
          </tr>
          <tr><th></th><td></td></tr>
          <tr>
            <th></th>
            <td>
              <?php echo $iosConfig ? '' : "<a href='https://xuanim.com/push-ios.html' target='_blank' rel='noreferrer'>{$lang->push->goToGet}<i class='icon icon-double-angle-right'></i></a>";?>
            </td>
          </tr>
          <tr>
            <th></th>
            <td colspan='2'>
              <?php echo $iosConfig ? html::a($this->inlink('edit', 'type=ios'), $lang->edit, "class='btn btn-primary' data-toggle='modal'") : html::submitButton();?>
            </td>
          </tr>
        </table>
      </form>
    </div>
  </div>
</div>
<script>
$.setAjaxForm('#pushIos');
$.setAjaxForm('#pushGlobal');
</script>
<?php include '../../common/view/footer.html.php';?>
