<?php
/**
 * The lang view file of setting module of XXB.
 *
 * @copyright   Copyright 2009-2020 青岛易软天创网络科技有限公司(QingDao Nature Easy Soft Network Technology Co,LTD, www.cnezsoft.com)
 * @license     ZOSL (https://zpl.pub/page/zoslv1.html)
 * @author      Yidong Wang <yidong@cnezsoft.com>
 * @package     setting
 * @version     $Id$
 * @link        https://xuanim.com
 */
?>
<?php include $app->getModuleRoot() . '/common/view/header.lite.html.php';?>
<?php
/**
 * $errCode posible values:
 * ION_LICENSE_NOT_FOUND        = 6;
 * ION_LICENSE_CORRUPT          = 7;
 * ION_LICENSE_EXPIRED          = 8;
 * ION_LICENSE_SERVER_INVALID   = 11;
 */
?>
<div id='main'>
  <div class='text-center' id='logo'>
    <?php echo html::image($this->config->webRoot . 'theme/default/images/main/logo-w.png'); ?>
  </div>
  <div class='panel panel-danger'>
    <div class='panel-heading'>
      <h2><i class='icon icon-warning-sign icon-2x'></i> &nbsp;<?php echo $lang->help->errorTitles[$licenseData->errType] ?></h2>
    </div>
    <div class='panel-body'>
      <p style='font-size: 15px;'>
      <?php
          if($licenseData->errType == 'expired')
          {
              echo sprintf($lang->help->errorMessages[$licenseData->errType], $licenseData->expireDate);
          }
          else
          {
              echo $lang->help->errorMessages[$licenseData->errType];
          }
      ?>
      </p>
    </div>
    <div class='panel-footer actions'>
      <a href='<?php echo $applyOfficialLicenseUrl;?>' class='btn' target='_blank' data-trigger='hover' data-content='<?php echo $lang->help->officialLicenseTip;?>' data-placement='top' data-toggle='popover' data-container='body'><i class='icon icon-external-link-sign'></i> <?php echo $lang->help->applyOfficialLicense?></a>
      <a href='#renewModal' class='btn' data-toggle='modal'data-position='center'><i class='icon icon-repeat'></i> <?php echo $lang->help->applyFreeLicense?></a>
      <a href='#contactModal' class='btn' data-toggle='modal'data-position='center'><i class='icon icon-comments-alt'></i> <?php echo $lang->help->contactInfo?></a>
      <a href='#importModal' class='btn' data-toggle='modal'data-position='center'><i class='icon icon-cloud-upload'></i> <?php echo $lang->help->importLicense?></a>
    </div>
  </div>
</div>
<div class='modal fade' id='renewModal'>
  <div class='modal-dialog'>
    <div class='modal-content'>
      <div class='modal-header'>
        <button type='button' class='close' data-dismiss='modal'>&times;</button>
        <h4 class='modal-title'><i class='icon icon-repeat text-muted'></i> <?php echo $lang->help->applyFreeLicense;?></h4>
      </div>
      <div class='modal-body'>
        <p><?php echo $lang->help->freeLicenseTip;?></p>
        <p><?php echo $lang->help->freeLicenseImportTip;?></p>
        <p><?php echo sprintf($lang->help->importLicenseSteps, $this->app->getBasePath()); ?></p>
        <p><a class='btn btn-primary' id='downloadBtn' href='<?php echo $freeLicenseAPI?>' target='_blank'><i class='icon icon-download'></i> <?php echo $lang->help->downloadLicense;?></a></p>
      </div>
    </div>
  </div>
</div>
<div class='modal fade' id='importModal'>
  <div class='modal-dialog'>
    <div class='modal-content'>
      <div class='modal-header'>
        <button type='button' class='close' data-dismiss='modal'>&times;</button>
        <h4 class='modal-title'><i class='icon icon-cloud-upload text-muted'></i> <?php echo $lang->help->importLicense;?></h4>
      </div>
      <div class='modal-body'>
        <h3><?php echo $lang->help->importLicenseTip?></h3>
        <p><?php echo sprintf($lang->help->importLicenseSteps, $this->app->getBasePath()); ?></p>
      </div>
    </div>
  </div>
</div>
<div class='modal fade' id='contactModal'>
  <div class='modal-dialog'>
    <div class='modal-content'>
      <div class='modal-header'>
        <button type='button' class='close' data-dismiss='modal'>&times;</button>
        <h4 class='modal-title'><i class='icon icon-comments-alt text-muted'></i> <?php echo $lang->help->contactInfo;?></h4>
      </div>
      <div class='modal-body'>
        <h3><?php echo $lang->help->contactTip?></h3>
        <table class='table table-bordered'>
        <tbody>
            <?php if(isset($licenseData->mobile) && !empty($licenseData->mobile)):?>
            <tr>
            <th><?php echo $lang->help->mobile?></th>
            <td><a href='tel:<?php echo $licenseData->mobile?>' target='_blank'><?php echo $licenseData->mobile?></a></td>
            </tr>
            <?php endif;?>
            <?php if(isset($licenseData->email) && !empty($licenseData->email)):?>
            <tr>
            <th><?php echo $lang->help->email?></th>
            <td><a href='mailto:<?php echo $licenseData->email?>' target='_blank'><?php echo $licenseData->email?></a></td>
            </tr>
            <?php endif;?>
            <?php if(isset($licenseData->qq) && !empty($licenseData->qq)):?>
            <tr>
            <th><?php echo $lang->help->qq?></th>
            <td><?php echo $licenseData->qq?></td>
            </tr>
            <?php endif;?>
            <tr>
            <th><?php echo $lang->help->site?></th>
            <td><a href='https://xuanim.com' target='_blank'>https://xuanim.com</a></td>
            </tr>
        </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
<script>
$(function()
{
    $('[data-toggle="popover"]').popover();

    var $downloadBtn = $('#downloadBtn');
    $downloadBtn.on('click', function()
    {
        $downloadBtn.addClass('disabled');
        setTimeout(function()
        {
            $downloadBtn.removeClass('disabled');
        }, 5000);
    });
});
</script>
</body>
</html>
