<?php
class myBlock extends control
{
    /**
     * Get content when block is status
     *
     * @param  object    $block
     * @access public
     * @return string
     */
    public function printLicenseBlock($blockID)
    {
        $block = $this->block->getByID($blockID);
        if(empty($block)) return false;

        $license = $this->loadModel('license')->getLisenceInfo();

        if(!$license->avaliable)
        {
            return die('<div style="height: 100%; display: flex; flex-direction: column; justify-content: center; align-items: center"><p><i class="icon icon-warning-sign icon-3x text-danger"></i></p><h3>' . $this->lang->license->licenseUnavailable . '</h3><br>' . html::a('', $this->lang->license->uploadLicense, 'class="btn btn-default btn-sm iframe" data-iframe="' . helper::createLink('license', 'uploadLicense') . '"') .'</div>');
        }

        $statusTextClass = '';
        if($license->expired)   $statusTextClass = 'text-danger';
        if($license->waiting)   $statusTextClass = 'text-info';
        if($license->effective) $statusTextClass = 'text-success';
        $startDate  = empty($license->startDate) ? $this->lang->license->unlimited : formatTime($license->startDate, DT_DATE3);
        $expireDate = empty($license->expireDate) ? $this->lang->license->unlimited : formatTime($license->expireDate, DT_DATE3);
        $userLimit  = empty($license->user) ? $this->lang->license->unlimited : sprintf($this->lang->license->userLimitText, $license->user);
        $mac        = empty($license->mac) ? $this->lang->license->unlimited : $license->mac;
        $ip         = empty($license->ip) ? $this->lang->license->unlimited : $license->ip;
        $conference = (isset($license->unlimitedParticipants) && $license->unlimitedParticipants) ? $this->lang->license->unlimited : $this->lang->license->conferenceLimited;

        $html = '<div style="padding: 10px"><table><tr>';
        $html .= '<td><table class="table table-form"><tbody>';
        $html .=   '<tr>';
        $html .=     "<th>{$this->lang->license->licensedTo}</th>";
        $html .=     "<td><strong>{$license->company}</strong></td>";
        $html .=   '</tr>';
        $html .=   '<tr>';
        $html .=     "<th>{$this->lang->license->status}</th>";
        $html .=     "<td><strong class='$statusTextClass'>{$this->lang->license->statusList[$license->status]}</strong></td>";
        $html .=   '</tr>';
        $html .=   '<tr>';
        $html .=     "<th>{$this->lang->license->startDate}</th>";
        $html .=     "<td>{$startDate}</td>";
        $html .=   '</tr>';
        $html .=   '<tr>';
        $html .=     "<th>{$this->lang->license->expireDate}</th>";
        $html .=     "<td>{$expireDate}";
        if(!empty($license->expireDate)) $html.= " &nbsp; ".html::a($this->lang->license->upgradeUrl, $this->lang->license->upgrade, 'target="_blank" rel="noreferrer noopener"');
        $html .=     "</td>";
        $html .=   '</tr>';
        $html .=   '<tr>';
        $html .=     "<th>MAC</th>";
        $html .=     "<td class='code'>{$mac}</td>";
        $html .=   '</tr>';
        $html .=   '<tr>';
        $html .=     "<th>IP</th>";
        $html .=     "<td class='code'>{$ip}</td>";
        $html .=   '</tr>';
        $html .= '</tbody></table></td>';
        $html .= '<td><table class="table table-form"><tbody>';
        $html .=   '<tr>';
        $html .=     "<th>{$this->lang->license->userLimit}</th>";
        $html .=     "<td>{$userLimit}</td>";
        $html .=   '</tr>';
        $html .=   '<tr>';
        $html .=     "<th>{$this->lang->license->conferencePermission}</th>";
        $html .=     "<td>{$conference}</td>";
        $html .=   '</tr>';
        $html .=   '<tr>';
        $html .=     "<th>{$this->lang->license->permissions}</th>";
        $html .=     '<td><ul style="margin:0;">';
        foreach(explode(',', $license->permissions) as $permission) $html .= empty($permission) ? '' : "<li>$permission</li>";
        $html .=     '</ul></td>';
        $html .=   '</tr>';
        $html .=   '<tr>';
        $html .=     '<th />';
        $html .=     '<td>' . html::a('', $this->lang->license->uploadLicense, 'class="btn btn-default btn-sm iframe" data-iframe="' . helper::createLink('license', 'uploadLicense') . '"') . '</td>';
        $html .=   '</tr>';
        $html .= '</tbody></table></td></tr></table></div>';

        die($html);
    }
}
